@echo off
REM ═══════════════════════════════════════════════════════════════════════════
REM Windows Build Script for Unified Micro-BigG Framework
REM ═══════════════════════════════════════════════════════════════════════════

echo.
echo ═══════════════════════════════════════════════════════════════════════════
echo  UNIFIED MICRO AND BIGG FRAMEWORK - BUILD SCRIPT
echo  Integrating HDGL Precision with Emergent Constants
echo ═══════════════════════════════════════════════════════════════════════════
echo.

REM Check for GCC (MinGW)
where gcc >nul 2>&1
if %ERRORLEVEL% == 0 (
    echo [✓] Found GCC compiler
    echo [*] Compiling with GCC optimization flags...
    gcc -O3 -march=native -ffast-math -Wall unified_micro_bigG_framework.c -o unified_framework.exe -lm
    if %ERRORLEVEL% == 0 (
        echo [✓] Compilation successful!
        echo [*] Executable: unified_framework.exe
        echo.
        echo [*] Running framework...
        echo.
        unified_framework.exe
        goto :end
    ) else (
        echo [✗] GCC compilation failed
        goto :try_msvc
    )
)

:try_msvc
REM Check for MSVC
where cl >nul 2>&1
if %ERRORLEVEL% == 0 (
    echo [✓] Found MSVC compiler
    echo [*] Compiling with MSVC optimization flags...
    cl /O2 /fp:fast /Fe:unified_framework.exe unified_micro_bigG_framework.c
    if %ERRORLEVEL% == 0 (
        echo [✓] Compilation successful!
        echo [*] Executable: unified_framework.exe
        echo.
        echo [*] Running framework...
        echo.
        unified_framework.exe
        goto :end
    ) else (
        echo [✗] MSVC compilation failed
        goto :try_clang
    )
)

:try_clang
REM Check for Clang
where clang >nul 2>&1
if %ERRORLEVEL% == 0 (
    echo [✓] Found Clang compiler
    echo [*] Compiling with Clang optimization flags...
    clang -O3 -march=native -ffast-math -Wall unified_micro_bigG_framework.c -o unified_framework.exe -lm
    if %ERRORLEVEL% == 0 (
        echo [✓] Compilation successful!
        echo [*] Executable: unified_framework.exe
        echo.
        echo [*] Running framework...
        echo.
        unified_framework.exe
        goto :end
    ) else (
        echo [✗] Clang compilation failed
        goto :no_compiler
    )
)

:no_compiler
echo.
echo [✗] No C compiler found!
echo.
echo Please install one of the following:
echo.
echo 1. MinGW-w64 (Recommended for Windows)
echo    Download: https://www.mingw-w64.org/
echo    Or via MSYS2: pacman -S mingw-w64-x86_64-gcc
echo.
echo 2. Microsoft Visual Studio Build Tools
echo    Download: https://visualstudio.microsoft.com/downloads/
echo    Install: "Desktop development with C++"
echo.
echo 3. Clang/LLVM
echo    Download: https://releases.llvm.org/
echo.
echo After installation, run this script again.
echo.
pause
goto :eof

:end
echo.
echo ═══════════════════════════════════════════════════════════════════════════
echo  Build and execution complete!
echo ═══════════════════════════════════════════════════════════════════════════
echo.
pause
